package com.miapp.handbappscore.comandos;

import android.graphics.Color;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.miapp.handbappscore.*;

import java.util.ArrayList;
import java.util.Hashtable;

import static android.content.Context.LAYOUT_INFLATER_SERVICE;

public class TarjetaRojaComando extends ComandoExclusion {
    private boolean isEjecutado = false;

    public TarjetaRojaComando(Jugador jugador, View view) {
        super(jugador, view);
    }

    @Override
    public void Ejecutar() {
        jugador.setRoja(true);
        jugador.setExclusion(true);
        GameTime.disable(viewGroup);
        super.IniciarCronometro();
    }

    @Override
    public void Deshacer() {
        super.Deshacer();
        jugador.setRoja(false);
        jugador.setExclusion(false);
    }

    @Override
    protected void OnTick(long noUsado) {
        super.OnTick(noUsado);

        if (!tiempoRestanteExclusion.isDuracionMayorQueCero() && !isEjecutado) {
            SustituirExpulsado();
            isEjecutado = true;
        }
    }

    private void SustituirExpulsado() {
        Equipo equipoObjetivo = Equipo.GetEquipoJugador(jugador);
        ViewGroup viewGroup = (ViewGroup) view.getParent().getParent();

        equipoObjetivo.getSuplentes();
        ViewGroup vg = (ViewGroup) viewGroup.getParent().getParent();
        ImageView imageview;
        String dorsal;
        ArrayList<Jugador> suplentes = new ArrayList<>();
        Hashtable<Jugador, ViewGroup> viewGroupSuplentes = new Hashtable<Jugador, ViewGroup>();
        for (int itemPos = 0; itemPos < vg.getChildCount(); itemPos++) {
            ViewGroup viewG = (ViewGroup) vg.getChildAt(itemPos);
            for (int j = 0; j< viewG.getChildCount(); j++) {
                View view = viewG.getChildAt(j);
                if (view instanceof ImageView) {
                    imageview = (ImageView) view;
                    dorsal = (String) imageview.getTag();
                    String[] split = dorsal.split("-");
                    dorsal = split[0];
                    Jugador jg = equipoObjetivo.selJugador(Integer.parseInt(dorsal));
                    if (!jg.getEsTitular()) {
                        suplentes.add(jg);
                        viewGroupSuplentes.put(jg, (ViewGroup) vg.getChildAt(itemPos));
                    }
                }
            }
        }
        // inflate the layout of the popup window
        LayoutInflater inflater = (LayoutInflater) LifecycleManager.getContext().getSystemService(LAYOUT_INFLATER_SERVICE);
        View popupView = inflater.inflate(R.layout.roja_layout, null);
        LinearLayout linearLayout = new LinearLayout(LifecycleManager.getContext());
        LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        linearLayout.setOrientation(LinearLayout.HORIZONTAL);
        linearLayout.setLayoutParams(linearParams);
        ViewGroup popGroup = (ViewGroup) popupView;
        popGroup.addView(linearLayout);
        // create the popup window
        int width = LinearLayout.LayoutParams.WRAP_CONTENT;
        int height = LinearLayout.LayoutParams.WRAP_CONTENT;
        boolean focusable = false; // Impedirá que el popup se cierre al pulsar fuera del mismo, hay que escoger un jugador para continuar
        final PopupWindow popupWindow = new PopupWindow(popupView, width, height, focusable);
        ImageButton[] button = new ImageButton[suplentes.size()];
        int i=0;
        for(Jugador s:suplentes){
            LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            params1.setMargins(0, 10, 0, 10);
            params1.gravity = Gravity.CENTER;
            LayoutInflater inflater2 = (LayoutInflater) LifecycleManager.getContext().getSystemService(LAYOUT_INFLATER_SERVICE);
            View itemBox;
            itemBox = inflater2.inflate(R.layout.camiseta, null);
            itemBox.setLayoutParams(params1);
            button[i] = (ImageButton)itemBox.findViewById(R.id.dorsalSuplente);
            GameTime.setCamiseta(button[i], s.getDorsal(), s.esInicial);
            String stringTitular="suplente";
            if(s.esTitular){
                stringTitular="titular";
            }
            linearLayout.addView(itemBox);
            button[i].setBackgroundColor(Color.TRANSPARENT);
            button[i].setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    ViewGroup viewJugador = viewGroupSuplentes.get(s);
                    s.setEsTitular(true);
                    LinearLayout auxTit = (LinearLayout) viewGroup.getParent();
                    int indexTit = (int) auxTit.getTag();
                    Log.d("indexTit", String.valueOf(indexTit));

                    LinearLayout aux = (LinearLayout) viewJugador;
                    int indexSup = (int) aux.getTag();
                    Log.d("indexSup", String.valueOf(indexSup));

                    LinearLayout container = (LinearLayout) auxTit.getParent();
                    container.removeView(auxTit);
                    container.removeView(aux);
                    container.addView(aux, indexTit);
                    aux.setTag(indexTit);
                    GameTime.enable(viewJugador);
                    popupWindow.dismiss();
                }
            });
            i++;
        }

        // which view you pass in doesn't matter, it is only used for the window tolken
        popupWindow.showAtLocation(view, Gravity.CENTER, 0, 0);
    }
}
