package com.miapp.handbappscore.comandos;

import android.view.View;
import com.miapp.handbappscore.*;

public class ExcluirJugadorComando extends ComandoExclusion{
    private TarjetaRojaComando tarjetaRojaComando;

    public ExcluirJugadorComando(Jugador jugador, View view) {
        super(jugador, view);
    }
    private boolean isEjecutado = false;

    @Override
    public void Ejecutar() {
        GameTime.disable(viewGroup);
        jugador.setExclusion(true);
        jugador.setNumExclusiones(jugador.getNumExclusiones() + 1);

        if(jugador.getNumExclusiones() >=3){
            tarjetaRojaComando = new TarjetaRojaComando(jugador, view);
            tarjetaRojaComando.Ejecutar();

            return;
        }

        super.IniciarCronometro();
    }

    @Override
    public void Deshacer() {
        super.Deshacer();

        jugador.setExclusion(false);
        jugador.setNumExclusiones(jugador.getNumExclusiones() - 1);
        tiempoRestanteExclusion = new Periodo(0);

        if (jugador.getNumExclusiones() < 3 && tarjetaRojaComando != null) {
            tarjetaRojaComando.Deshacer();
        }
    }

    @Override
    protected void OnTick(long noUsado) {
        super.OnTick(noUsado);

        if (!tiempoRestanteExclusion.isDuracionMayorQueCero() && !isEjecutado) {
            GameTime.enable(viewGroup);
            jugador.setExclusion(false);
            isEjecutado = true;
        }
    }
}
