package com.miapp.handbappscore.comandos;

import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.miapp.handbappscore.*;

public class ComandoExclusion implements IComando {
    private static int TIEMPO_EXCLUSION_EN_MS = 120000;

    protected final Jugador jugador;
    protected final View view;
    protected TextView vistaCronometro;
    protected ViewGroup viewGroup;

    protected  Periodo tiempoRestanteExclusion;

    public ComandoExclusion(Jugador jugador, View view) {
        this.jugador = jugador;
        this.view = view;
        this.tiempoRestanteExclusion = new Periodo(TIEMPO_EXCLUSION_EN_MS);
        viewGroup = (ViewGroup) view.getParent().getParent();
    }

    @Override
    public void Ejecutar() { }

    @Override
    public void Deshacer() {
        try {
            StopwatchWrapper.CancelarSubscripcionOnTick(this, ComandoExclusion.class.getDeclaredMethod("OnTick", long.class));
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        vistaCronometro.setVisibility((View.INVISIBLE));
    }

    protected void IniciarCronometro() {
        Equipo equipo = Equipo.GetEquipoJugador(jugador);

        vistaCronometro = TextViewManager.findViewById(ResourceIDsManager.GetIDCrono(equipo.getID(), equipo.getExcluidos()));
        vistaCronometro.setText("2:00");
        vistaCronometro.setVisibility(View.VISIBLE);

        try {
            StopwatchWrapper.SubscribirOnTick(this, ComandoExclusion.class.getDeclaredMethod("OnTick", long.class));
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    protected void OnTick(long tiempoRestanteMs) {
        if (!tiempoRestanteExclusion.isDuracionMayorQueCero()) {
            vistaCronometro.setVisibility(View.INVISIBLE);
        } else {
            tiempoRestanteExclusion.setDuracion(tiempoRestanteExclusion.getDuracionEnMs() - StopwatchWrapper.GetFrecuenciaActualizacion());
            vistaCronometro.setText(tiempoRestanteExclusion.ToString());
        }
    }
}
