package com.miapp.handbappscore.comandos;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.miapp.handbappscore.*;

public class AñadirTiroJugadorComando  implements IComando{
    private final Jugador jugador;
    private final Equipo equipo;
    private final View view;
    private final long tiempoCuandoOcurrioMs;

    public AñadirTiroJugadorComando(Jugador jugador, View view, long tiempoCuandoOcurrioMs) {
        this.jugador = jugador;
        this.equipo = Equipo.GetEquipoJugador(jugador);
        this.view = view;
        this.tiempoCuandoOcurrioMs = tiempoCuandoOcurrioMs;
    }

    @Override
    public void Ejecutar() {
        GameTime.actualizarVista(view, 1);
        jugador.setTiro(1);
        DBManager.guardarEvento(jugador.getDorsal(), equipo.getNombreEquipo(), "tiro", jugador.getEsInicial()+"", tiempoCuandoOcurrioMs);
        DBManager.guardarEquipo(equipo, "equipo" + equipo.getID());
    }

    @Override
    public void Deshacer() {
        GameTime.actualizarVista(view, -1);
        jugador.setTiro(-1);

    }
}
