package com.miapp.handbappscore.comandos;

import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.miapp.handbappscore.*;

public class AñadirGolJugadorComando implements IComando{
    private final Jugador jugador;
    private final Equipo equipo;
    private final View view;
    private final ViewGroup viewGroup;
    private final long tiempoCuandoOcurrioMs;
    private AñadirTiroJugadorComando añadirTiroJugadorComando;
    private AñadirGolEquipoComando añadirGolEquipoComando;
    private View viewTiro;

    public AñadirGolJugadorComando(Jugador jugador, View view, long tiempoCuandoOcurrioMs) {
        this.jugador = jugador;
        this.equipo = Equipo.GetEquipoJugador(jugador);
        this.view = view;
        viewGroup = (ViewGroup) view.getParent();
        this.tiempoCuandoOcurrioMs = tiempoCuandoOcurrioMs;
    }

    @Override
    public void Ejecutar() {
        GameTime.actualizarVista(view, 1);
        for (int itemPos = 0; itemPos < viewGroup.getChildCount(); itemPos++) {
            View view = viewGroup.getChildAt(itemPos);
            if (view instanceof TextView) {
                TextView textView = (TextView) view;
                if(textView.getId()== R.id.tirosLabel){
                    viewTiro = textView;
                }
            }
        }

        añadirGolEquipoComando = new AñadirGolEquipoComando(equipo);
        añadirGolEquipoComando.Ejecutar();
        añadirTiroJugadorComando = new AñadirTiroJugadorComando(jugador, viewTiro, tiempoCuandoOcurrioMs);
        añadirTiroJugadorComando.Ejecutar();
        jugador.setGoles(1);

        DBManager.guardarEvento(jugador.getDorsal(), equipo.getNombreEquipo(), "gol", jugador.getEsInicial()+"", tiempoCuandoOcurrioMs);
        DBManager.guardarEquipo(equipo, "equipo" + equipo.getID());
    }

    @Override
    public void Deshacer() {
        GameTime.actualizarVista(view, -1);
        añadirGolEquipoComando.Deshacer();
        jugador.setGoles(-1);
        añadirTiroJugadorComando.Deshacer();
    }
}
