package com.miapp.handbappscore.comandos;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import com.miapp.handbappscore.*;

import java.time.Duration;

public class AñadirGolEquipoComando extends AppCompatActivity implements IComando {
    private final Equipo equipo;
    private final TextView view;

    public AñadirGolEquipoComando(Equipo equipo) {
        this.equipo = equipo;
        this.view = TextViewManager.findViewById(ResourceIDsManager.GetIDMarcador(equipo.getID()));
    }

    @Override
    public void Ejecutar() {
        equipo.setGoles(1);
        DBManager.guardarEquipo(equipo, "equipo" + equipo.getID());

        GameTime.actualizarVista(view, 1);
    }

    @Override
    public void Deshacer() {
        equipo.setGoles(-1);
        DBManager.guardarEquipo(equipo, "equipo" + equipo.getID());
        GameTime.actualizarVista(view, -1);
    }
}
