package com.miapp.handbappscore.comandos;

import android.os.Build;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.miapp.handbappscore.DBManager;
import com.miapp.handbappscore.Equipo;
import com.miapp.handbappscore.GameTime;
import com.miapp.handbappscore.Jugador;

public class AñadirFaltaJugadorComando implements IComando{
    private final Jugador jugador;
    private final Equipo equipo;
    private final View view;
    private final long tiempoCuandoOcurrioMs;

    public AñadirFaltaJugadorComando(Jugador jugador, View view, long tiempoCuandoOcurrioMs) {
        this.jugador = jugador;
        this.equipo = Equipo.GetEquipoJugador(jugador);
        this.view = view;
        this.tiempoCuandoOcurrioMs = tiempoCuandoOcurrioMs;
    }

    @Override
    public void Ejecutar() {
        GameTime.actualizarVista(view);
        jugador.setFaltas(1);
        DBManager.guardarEvento(jugador.getDorsal(), equipo.getNombreEquipo(), "falta", jugador.getEsInicial()+"", tiempoCuandoOcurrioMs);
        DBManager.guardarEquipo(equipo, "equipo" + equipo.getID());
    }

    @Override
    public void Deshacer() {
        jugador.setRecuperaciones(-1);
    }
}

