package com.miapp.handbappscore;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.CountDownTimer;
import android.util.Pair;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.Semaphore;

public class StopwatchWrapper {
    private static final long FRECUENCIA_DE_ACTUALIZACION_MS = 1000;

    private static final List<Pair<Object, Method>> subscribersOnTicks = new ArrayList<>();
    private static final List<Pair<Object, Method>> subscribersOnFinish = new ArrayList<>();

    private static long tiempoRestanteMs = Partido.GetInstance().getDuracion() * 60000;

    private static CountDownTimer stopwatch;

    public static long GetTiempoRestanteEnMs() {
        return tiempoRestanteMs;
    }

    public static void SetTiempoRestanteEnMS(long tiempoRestante){
        tiempoRestanteMs = tiempoRestante;
    }

    public static void SubscribirOnTick(Object object, Method method) {
        subscribersOnTicks.add(new Pair<>(object, method));
    }

    public static void CancelarSubscripcionOnTick(Object object, Method method) {
        subscribersOnTicks.remove(new Pair<>(object, method));
    }

    public static void SubscribirOnFinish(Object object, Method method) {
        subscribersOnFinish.add(new Pair<>(object, method));
    }

    public static void CancelarSubscripcionOnFinish(Object object, Method method) {
        subscribersOnFinish.remove(new Pair<>(object, method));
    }

    public static long GetFrecuenciaActualizacion() { return FRECUENCIA_DE_ACTUALIZACION_MS; }

    public static void Start() {
        stopwatch = new CountDownTimer(GetTiempoRestanteEnMs(), FRECUENCIA_DE_ACTUALIZACION_MS) {
            @Override
            public void onTick(long millisUntilFinished) {
                tiempoRestanteMs = millisUntilFinished;

                Iterator<Pair<Object, Method>> it = subscribersOnTicks.iterator();

                while (it.hasNext()) {
                    Object[] parameters = new Object[1];
                    parameters[0] = millisUntilFinished;
                    Pair<Object, Method> subscriber = it.next();

                    try {
                        subscriber.second.setAccessible(true);
                        subscriber.second.invoke(subscriber.first, parameters);
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    } catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onFinish() {
                Iterator<Pair<Object, Method>> it = subscribersOnFinish.iterator();

                while (it.hasNext()) {
                    Pair<Object, Method> subscriber = it.next();

                    try {
                        subscriber.second.setAccessible(true);
                        subscriber.second.invoke(subscriber.first);
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    } catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        };

        stopwatch.start();
    }
    public static void Stop() {
        stopwatch.cancel();
    }
}
