package com.miapp.handbappscore;

public class ResourceIDsManager {
    private static final int[] cronosExclusionEquipo1 = { R.id.cronoExclusionEq1, R.id.cronoExclusionEq12, R.id.cronoExclusionEq13,
            R.id.cronoExclusionEq14, R.id.cronoExclusionEq15, R.id.cronoExclusionEq16};
    private static final int[] cronosExclusionEquipo2 = { R.id.cronoExclusionEq2, R.id.cronoExclusionEq22, R.id.cronoExclusionEq23,
            R.id.cronoExclusionEq24, R.id.cronoExclusionEq25, R.id.cronoExclusionEq26};
    private static final int[][] cronosExclusionPorEquipo = { cronosExclusionEquipo1, cronosExclusionEquipo2};

    private static final int[] camisetasTitulares = { R.drawable.ct1, R.drawable.ct2, R.drawable.ct3, R.drawable.ct4, R.drawable.ct5,
            R.drawable.ct6, R.drawable.ct7, R.drawable.ct8, R.drawable.ct9, R.drawable.ct10,
            R.drawable.ct11, R.drawable.ct12, R.drawable.ct13, R.drawable.ct14,R.drawable.ct15,
            R.drawable.ct16, R.drawable.ct17,R.drawable.ct18, R.drawable.ct19, R.drawable.ct20};

    private static final int[] camisetasJugadores = { R.drawable.cj1, R.drawable.cj2, R.drawable.cj3, R.drawable.cj4, R.drawable.cj5,
            R.drawable.cj6, R.drawable.cj7, R.drawable.cj8, R.drawable.cj9, R.drawable.cj10,
            R.drawable.cj11, R.drawable.cj12, R.drawable.cj13, R.drawable.cj14,R.drawable.cj15,
            R.drawable.cj16, R.drawable.cj17,R.drawable.cj18, R.drawable.cj19, R.drawable.cj20};

    private static final int[] marcadores = { R.id.marcadorEq1, R.id.marcadorEq2};


    /**
     * @param isTitular indica si es el jugador es titular o no
     * @param numeroJugador indica el numero del jugador
     * @return la id de la camiseta del jugador pasado como parametro
     *
     * @throws IllegalArgumentException si el numero de jugador no esta asociado a ninguna id de camiseta.
     */
    public static int GetIDCamiseta(boolean isTitular, int numeroJugador) {
        ComprobarValidezNumeroJugador(isTitular, numeroJugador);

        if (isTitular) {
            return camisetasTitulares[numeroJugador - 1];
        } else {
            return camisetasJugadores[numeroJugador - 1];
        }
    }

    /**
     * Comprueba si hay una id de camiseta para el numero de jugador dado.
     * @param isTitular indica si es el jugador es titular o no
     * @param numeroJugador indica el numero del jugador
     *
     * @throws IllegalArgumentException si el numero de jugador no esta asociado a ninguna id de camiseta.
     */
    private static void ComprobarValidezNumeroJugador(boolean isTitular, int numeroJugador) {
        int numeroDeCamisetasDisponibles = isTitular ? camisetasTitulares.length : camisetasJugadores.length;

        if (numeroJugador < 1 || numeroJugador > numeroDeCamisetasDisponibles) {
            throw new IllegalArgumentException("El numero de jugador debe estar entre 1 y " + numeroDeCamisetasDisponibles + " y el introducido es: " + numeroJugador);
        }
    }

    public static int GetIDMarcador(int numeroEquipo) {
        ComprobarNumeroEquipo(numeroEquipo);

        return marcadores[numeroEquipo - 1];
    }

    public static int GetIDCrono(int numeroEquipo, int numeroCrono) {
        ComprobarNumeroCronoEnEquipo(numeroEquipo, numeroCrono);

        return cronosExclusionPorEquipo[numeroEquipo - 1][numeroCrono - 1];
    }

    public static int GetNumeroDeCronosEnEquipo(int numeroEquipo) {
        ComprobarNumeroEquipo(numeroEquipo);

        if (numeroEquipo == 1) {
            return cronosExclusionEquipo1.length;
        } else {
            return cronosExclusionEquipo2.length;
        }
    }

    private static void ComprobarNumeroCronoEnEquipo(int numeroEquipo, int numeroCrono) {
        ComprobarNumeroEquipo(numeroEquipo);
        int cronosDisponiblesEnEquipo = numeroEquipo == 1 ? cronosExclusionEquipo1.length : cronosExclusionEquipo2.length;

        if (numeroCrono < 1 || numeroCrono > cronosDisponiblesEnEquipo) {
            throw new IllegalArgumentException("El numero de crono debe estar entre 1 y " + cronosDisponiblesEnEquipo + " y el introducido es: " + numeroCrono);
        }
    }

    private static void ComprobarNumeroEquipo(int numeroEquipo) {
        if (numeroEquipo < 1 || numeroEquipo > Equipo.GetNumeroMaximoEquipos()) {
            throw new IllegalArgumentException("El numero de equipo debe estar entre 1 y " + Equipo.GetNumeroMaximoEquipos() + " y el introducido es: " + numeroEquipo);
        }
    }

}