package com.miapp.handbappscore;

public class Periodo {
    private long duracionEnMs;

    public Periodo(long duracionEnMs) {
        this.duracionEnMs = duracionEnMs;
    }

    public long getDuracionEnMs() {
        return duracionEnMs;
    }

    public long getDuracionMin() {
        return duracionEnMs / 60000;
    }

    public void setDuracion(long duracionEnMs) {
        this.duracionEnMs = duracionEnMs;
    }

    public boolean isDuracionMayorQueCero() { return duracionEnMs > 0; }

    public String ToString() {
        long minutos = getDuracionMin();
        long segundos = (duracionEnMs - (minutos * 60000)) / 1000;

        String zeroMinutos = minutos < 10 ? "0" : "";
        String zeroSegundos = segundos < 10 ? "0" : "";

        return zeroMinutos + minutos + ":" + zeroSegundos + segundos;
    }
}
