package com.miapp.handbappscore;


import android.content.pm.ActivityInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Typeface;
import android.media.Image;
import android.os.Build;
import android.util.Log;
import android.view.*;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import android.os.Bundle;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;

public class MatchActivity extends AppCompatActivity {

    public Equipo equipo1 = new Equipo(1);
    public Equipo equipo2 = new Equipo(2);
    public Partido partido = new Partido();
    public Estadistica evento = new Estadistica();
    public ArrayList<Estadistica> eventos = new ArrayList<Estadistica>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_match);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            final WindowInsetsController insetsController = getWindow().getInsetsController();
            if (insetsController != null) {
                insetsController.hide(WindowInsets.Type.statusBars());
            }
        } else {
            getWindow().setFlags(
                    WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN
            );
        }

        MatchDB conn=new MatchDB(getApplicationContext(),"bd_partidos",null,1);
        String[] parametros={String.valueOf(GlobalVars.IDRESULTANTE)};
        SQLiteDatabase db=conn.getReadableDatabase();
        try{
            Cursor cursor =db.query(GlobalVars.TABLA_PARTIDO, new String[]{"equipo1, equipo2", "estadistica"},"_id=?",parametros,null,null,null);
            cursor.moveToFirst();
            String storedEquipo1String = cursor.getString(0);
            String storedEquipo2String = cursor.getString(1);
            String storedEstadisticaString = cursor.getString(2);
            Gson gson = new Gson();
            equipo1 = gson.fromJson(storedEquipo1String, Equipo.class);
            equipo2 = gson.fromJson(storedEquipo2String, Equipo.class);
            Type listType = new TypeToken<ArrayList<Estadistica>>(){}.getType();
            eventos = gson.fromJson(storedEstadisticaString, listType);
            cursor.close();
        } catch (Exception e){
            Log.d("EL equipo no existe","todavía");
        }

        parametros= new String[]{String.valueOf(GlobalVars.IDRESULTANTE)};
        String[] campos={"partes","duracion","numTitulares"};


        ScrollView scrollView = new ScrollView(this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        scrollView.setLayoutParams(layoutParams);

        LinearLayout linearLayout = new LinearLayout(this);
        LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        linearLayout.setOrientation(LinearLayout.VERTICAL);
        linearLayout.setLayoutParams(linearParams);

        Typeface customFont = Typeface.createFromAsset(getAssets(), "fonts/digital7.ttf");
        scrollView.addView(linearLayout);
        if(eventos!=null) {
            for (int i = 0; i < eventos.size(); i++) {
                LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                params1.setMargins(0, 10, 0, 10);
                params1.gravity = Gravity.CENTER;
                LayoutInflater inflater = (LayoutInflater) getSystemService(LAYOUT_INFLATER_SERVICE);
                View itemBox;
                Equipo equipo = Equipo.getEquipoByName(eventos.get(i).getNombreEq());
                Jugador j = equipo.selJugador(eventos.get(i).getDorsalJugador());
                switch (eventos.get(i).getEvento()){
                    case"sustitucion":
                        itemBox = inflater.inflate(R.layout.sustitute_layout, null);
                        ImageView iv = (ImageView) itemBox.findViewById(R.id.jugadorView);
                        setCamiseta(iv, eventos.get(i).getDorsalJugador(), j.getEsInicial());
                        Jugador js = equipo.selJugador(eventos.get(i).getDorsalSuplente());
                        ImageView sup = (ImageView) itemBox.findViewById(R.id.suplenteView);
                        setCamiseta(sup, eventos.get(i).getDorsalSuplente(), js.getEsInicial());
                        break;
                    case "tiempoMuerto":
                        itemBox = inflater.inflate(R.layout.timeout_layout, null);
                        break;
                    default:
                        itemBox = inflater.inflate(R.layout.event_layout, null);
                        iv = (ImageView) itemBox.findViewById(R.id.jugadorView);
                        setCamiseta(iv, eventos.get(i).getDorsalJugador(), j.getEsInicial());
                }
                TextView labelEquipo = (TextView) itemBox.findViewById(R.id.labelEquipo);
                TextView labelEvento = (TextView) itemBox.findViewById(R.id.labelEvento);
                TextView labelTiempo = (TextView) itemBox.findViewById(R.id.labelTiempo);
                labelTiempo.setTypeface(customFont);
                labelEquipo.setText(eventos.get(i).getNombreEq());
                labelEvento.setText(eventos.get(i).getEvento());
                ImageView v = (ImageView) itemBox.findViewById(R.id.eventView);
                int minuto = GlobalVars.MATCH_TIME - eventos.get(i).getMinuto() - 1;
                int segundo = 60 - eventos.get(i).getSegundos();
                String muestraTiempo;

                muestraTiempo = "";

                if (minuto < 10) {
                    muestraTiempo += "0";
                }

                muestraTiempo += minuto;
                muestraTiempo += ":";

                if (segundo < 10) {
                    muestraTiempo += "0";
                }
                muestraTiempo += segundo;
                labelTiempo.setText(muestraTiempo);
                setEventoView(v, eventos.get(i).getEvento());
                linearLayout.addView(itemBox);
            }
        }

        LinearLayout linearLayout1 = findViewById(R.id.scrollEstadistica);
        if (linearLayout1 != null) {
            linearLayout1.addView(scrollView);
        }

        TextView marcador1 = findViewById(R.id.marcadorEq1Est);
        TextView marcador2 = findViewById(R.id.marcadorEq2Est);
        marcador1.setText(String.valueOf(equipo1.getGoles()));
        marcador2.setText(String.valueOf(equipo2.getGoles()));
        marcador1.setTypeface(customFont);
        marcador2.setTypeface(customFont);
    }

    private void setEventoView(ImageView v, String evento) {
        switch (evento){
            case"tiro":
                 v.setImageResource(R.drawable.tiro);
                break;
            case"gol":
                v.setImageResource(R.drawable.gol);
                break;
            case"amarilla":
                v.setImageResource(R.drawable.tarjetaamarilla);
                break;
            case"penalty":
                v.setImageResource(R.drawable.penalti);
                break;
            case"tRoja":
                v.setImageResource(R.drawable.tarjetaroja);
                break;
            case"exclu":
                v.setImageResource(R.drawable.exclusion);
                break;
            case"falta":
                v.setImageResource(R.drawable.falta);
                break;
            case"recuperacion":
                v.setImageResource(R.drawable.recuperacion);
                break;
            case"sustitucion":
                v.setImageResource(R.drawable.cambio);
                break;
            case"tiempoMuerto":
                v.setImageResource(R.drawable.timeout);
                break;
        }
    }

    private void setCamiseta(ImageView imageview, int dorsal, boolean esTitular) {
        int id = ResourceIDsManager.GetIDCamiseta(esTitular, dorsal);
        imageview.setImageResource(id);
    }
}