package com.miapp.handbappscore;

import android.content.ContentValues;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Build;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import android.os.Bundle;
import android.database.sqlite.SQLiteDatabase;
import com.google.gson.Gson;

import java.lang.reflect.Type;


public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE); // Orientación de pantalla siempre en horizontal, en todas las activity.
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            final WindowInsetsController insetsController = getWindow().getInsetsController();
            if (insetsController != null) {
                insetsController.hide(WindowInsets.Type.statusBars());
            }
        } else {
            getWindow().setFlags(
                    WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN
            );
        }

        Partido partido = new Partido();
        Equipo equipo1 = null;
        Equipo equipo2 = null;

        MatchDB conn=new MatchDB(getApplicationContext(),"bd_partidos",null,1);
        String[] parametros={String.valueOf(GlobalVars.IDRESULTANTE)};
        SQLiteDatabase db=conn.getReadableDatabase();
        try{
            Cursor cursor =db.query(GlobalVars.TABLA_PARTIDO, new String[]{"equipo1, equipo2"},"_id=?",parametros,null,null,null);
            Log.d("Qué hay en cursor", String.valueOf(cursor.getCount()));
            cursor.moveToFirst();
            String storedEquipo1String = cursor.getString(0);
            String storedEquipo2String = cursor.getString(1);
            Gson gson = new Gson();
            equipo1 = gson.fromJson(storedEquipo1String, Equipo.class);
            equipo2 = gson.fromJson(storedEquipo2String, Equipo.class);
            cursor.close();
        } catch (Exception e){
            Log.d("EL equipo no existe","todavía");
        }

        parametros= new String[]{String.valueOf(GlobalVars.IDRESULTANTE)};
        String[] campos={"partes","duracion","numTitulares"};

        try {
            Cursor cursor =db.query(GlobalVars.TABLA_PARTIDO,campos,"_id=?",parametros,null,null,null);
            cursor.moveToFirst();
            GlobalVars.NUM_PARTS = cursor.getInt(0);
            partido.setPartes(GlobalVars.NUM_PARTS);
            GlobalVars.MATCH_TIME = cursor.getInt(1);
            partido.setDuracion(GlobalVars.MATCH_TIME);
            GlobalVars.MAX_TIT = cursor.getInt(2);
            partido.setNumTitulares(GlobalVars.MAX_TIT);
            cursor.close();
        }catch (Exception e){
            GlobalVars.MATCH_TIME = partido.getDuracion();
            GlobalVars.NUM_PARTS = partido.getPartes();
            GlobalVars.MAX_TIT = partido.getNumTitulares();
            Log.d("EL documento no existe","todavía");
        }
        TextView textTiem = findViewById(R.id.textTiempo);
        textTiem.setText("El partido durará " + GlobalVars.MATCH_TIME  + " minutos y constará de " + GlobalVars.NUM_PARTS + " partes con " + GlobalVars.MAX_TIT +" titulares en cada equipo.");
        if(GlobalVars.IDRESULTANTE<1) {
            guardarPartido(partido);
        }

        if(equipo1!=null) {
            if (equipo1.getNombreEquipo() != null) {
                TextView labelEquipo1 = findViewById(R.id.labelEquipo1);
                View b = labelEquipo1;
                b.setVisibility(View.VISIBLE);
                labelEquipo1.setText(equipo1.getNombreEquipo());
            }
        }
        if(equipo2!=null) {
            if (equipo2.getNombreEquipo() != null) {
                TextView labelEquipo2 = findViewById(R.id.labelEquipo2);
                View c = labelEquipo2;
                c.setVisibility(View.VISIBLE);
                labelEquipo2.setText(equipo2.getNombreEquipo());
            }
        }


        if(equipo1!=null&&equipo2!=null) {
            if (equipo1.getNombreEquipo() != "" && equipo2.getNombreEquipo() != "") {
                ImageButton aJugar = findViewById(R.id.aJugar);
                aJugar.setBackgroundColor(Color.TRANSPARENT);
                View aj = aJugar;
                aj.setVisibility(View.VISIBLE);
                aJugar.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        Intent intent = new Intent(MainActivity.this, GameTime.class);
                        startActivityForResult(intent, 0);
                    }
                });
            }
        }

        ImageButton img1 = findViewById(R.id.createMatch);
        img1.setBackgroundColor(Color.TRANSPARENT);
        img1.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {

            Intent intent = new Intent(MainActivity.this, SaveTeam1.class);
            startActivityForResult(intent, 0);
        }
        });

        ImageButton img2= findViewById(R.id.createMatch2);
        img2.setBackgroundColor(Color.TRANSPARENT);
        img2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MainActivity.this, SaveTeam2.class);
                startActivityForResult(intent, 0);
            }
        });

        Button cambiartiempo = findViewById(R.id.cambiarTiemposBoton);
        cambiartiempo.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(MainActivity.this, CambiarTiempos.class);
                startActivityForResult(intent, 0);
            }
        });
    }

    private void guardarPartido(Partido partido) {
        MatchDB conn=new MatchDB(this,"bd_partidos",null,1);

        SQLiteDatabase db=conn.getWritableDatabase();
        ContentValues values=new ContentValues();
        values.put("partes",partido.getPartes());
        values.put("duracion",partido.getDuracion());
        values.put("numTitulares",partido.getNumTitulares());

        GlobalVars.IDRESULTANTE = db.insert(GlobalVars.TABLA_PARTIDO,"partes",values);
        Log.d("Id registro", String.valueOf(GlobalVars.IDRESULTANTE));
        db.close();
    }
}