package com.miapp.handbappscore;

import android.os.Build;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.miapp.handbappscore.comandos.*;

import java.util.Hashtable;
import java.util.Map;

public class JugadoresViewModel {
    private final Map<Jugador, AñadirGolJugadorComando> comandosGolesJugadores = new Hashtable<>();
    private final Map<Equipo, AñadirGolEquipoComando> comandosGolesEquipo = new Hashtable<>();
    private final Map<Jugador, AñadirTiroJugadorComando> comandosTirosJugadores = new Hashtable<>();
    private final Map<Jugador, AñadirRecuJugadorComando> comandosRecuJugadores = new Hashtable<>();
    private final Map<Jugador, AñadirFaltaJugadorComando> comandosFaltaJugadores = new Hashtable<>();

    public JugadoresViewModel() {

    }

    public void AñadirGolJugador(Jugador jugador, View view, long tiempoActualMs) {
        AñadirGolJugadorComando comando = new AñadirGolJugadorComando(jugador, view, tiempoActualMs);
        comando.Ejecutar();
        comandosGolesJugadores.put(jugador, comando);
    }

    public void RestarGolJugador(Jugador jugador) {
        AñadirGolJugadorComando comando = comandosGolesJugadores.get(jugador);

        if (comando != null) {
            comando.Deshacer();
        }
    }

    public void AñadirGolEquipo(Equipo equipo) {
        AñadirGolEquipoComando comando = new AñadirGolEquipoComando(equipo);
        comando.Ejecutar();
        comandosGolesEquipo.put(equipo, comando);
    }

    public void RestarGolEquipo(Equipo equipo) {
        AñadirGolEquipoComando comando = comandosGolesEquipo.get(equipo);

        if (comando != null) {
            comando.Deshacer();
        }
    }

    public void AñadirTiroJugador(Jugador jugador, View view, long tiempoActualMs) {
        AñadirTiroJugadorComando comando = new AñadirTiroJugadorComando(jugador, view, tiempoActualMs);
        comando.Ejecutar();
        comandosTirosJugadores.put(jugador, comando);
    }


    public void AñadirRecuJugador(Jugador jugador, View view, long tiempoActualMs) {
        AñadirRecuJugadorComando comando = new AñadirRecuJugadorComando(jugador, view, tiempoActualMs);
        comando.Ejecutar();
        comandosRecuJugadores.put(jugador, comando);
    }

    public void AñadirFaltaJugador(Jugador jugador, View view, long tiempoActualMs) {
        AñadirFaltaJugadorComando comando = new AñadirFaltaJugadorComando(jugador, view, tiempoActualMs);
        comando.Ejecutar();
        comandosFaltaJugadores.put(jugador, comando);
    }
}
