package com.miapp.handbappscore;

import android.os.Parcel;
import android.os.Parcelable;

public class Jugador
{

    public int dorsal;  //Dorsal del jugador.
    public int goles; //goles marcados por el jugador.
    public int tiro;
    public int faltas; //faltas cometidas por el jugador.
    public int amarillas;
    public boolean roja; //booleano que indica si el jugador está expulsado.
    public int lanzaPenalty;
    public int recuperaciones;
    public boolean esTitular;
    public int numExclusiones;
    public boolean exclusion; //Booleano que indica si el jugador está excluido.
    public boolean esInicial; //Booleano que inidica si el jugador saltó de inicio al campo

    /*
    *
    * Posible implementación del portero
    *
    * private boolean esPortero;
    * private int paradas;
    *
     */

    public Jugador() {
        this.dorsal = 0;
        this.goles = 0;
        this.tiro = 0;
        this.faltas = 0;
        this.amarillas = 0;
        this.roja = false;
        this.lanzaPenalty = 0;
        this.recuperaciones = 0;
        this.numExclusiones = 0;
        this.esTitular = false;
        this.exclusion = false;
        this.esInicial = false;
    }

    public void setDorsal(int d) {
        this.dorsal = d;
    }

    public int getDorsal(){
        return this.dorsal;
    }

    public void setGoles(int g){
    this.goles = g + this.goles;
}

    public void setEsInicial(boolean i){
        this.esInicial = i;
    }

    public boolean getEsInicial(){
        return this.esInicial;
    }

    public int getGoles() {
        return this.goles;
    }

    public void setNumExclusiones(int e){
        this.numExclusiones = e + this.numExclusiones;
    }

    public int getNumExclusiones() {
        return this.numExclusiones;
    }

    public void setTiro(int t){
        this.tiro = t + this.tiro;
    }

    public int getTiro() {
        return this.tiro;
    }

    public void setFaltas(int f){
        this.faltas = f + this.faltas;
    }

    public int getFaltas() {
        return this.faltas;
    }

    public void setAmarillas(int a){
        this.amarillas = a + this.amarillas;
    }

    public int getAmarillas() {
        return this.amarillas;
    }

    public void setRoja(boolean roja){
        this.roja = roja;
    }

    public boolean getRoja() {
        return this.roja;
    }

    public void setLanzaPenalty(int lp){
        this.lanzaPenalty = lp + this.lanzaPenalty;
    }

    public int getLanzaPenalty() {
        return lanzaPenalty;
    }

    public void setRecuperaciones(int r){
        this.recuperaciones = r + this.recuperaciones;
    }

    public int getRecuperaciones() {
        return recuperaciones;
    }

    public void setEsTitular(boolean esTitular){
        this.esTitular = esTitular;
    }

    public boolean getEsTitular() {
        return esTitular;
    }

    public void setExclusion(boolean exc){
        this.exclusion = exc;
    }

    public boolean getExclusion() {
        return exclusion;
    }

 }
