package com.miapp.handbappscore;

import android.content.*;
import android.content.pm.ActivityInfo;
import android.graphics.*;
import android.os.Build;
import android.provider.Settings;
import android.view.*;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.widget.*;
import android.os.Bundle;

public class GameTime extends AppCompatActivity {

    public Equipo equipo1 = Equipo.getEquipo(0);
    public Equipo equipo2 = Equipo.getEquipo(1);
    boolean atras = false;
    public Typeface customFont;

    private CronoViewModel cronoViewModel;
    private JugadoresViewModel jugadoresViewModel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        customFont = Typeface.createFromAsset(getAssets(), "fonts/digital7.ttf");
        LifecycleManager.Iniciar(this, this);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.gametime);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            final WindowInsetsController insetsController = getWindow().getInsetsController();
            if (insetsController != null) {
                insetsController.hide(WindowInsets.Type.statusBars());
            }
        } else {
            getWindow().setFlags(
                    WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN
            );
        }
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON,
                WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);

        DBManager.CreateDB(equipo1, equipo2, getApplicationContext());

        /*
        PARÁMETROS PARA EL SCROLL DEL EQUIPO 1
         */

        ScrollView scrollView = new ScrollView(this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        scrollView.setLayoutParams(layoutParams);

        LinearLayout linearLayout = new LinearLayout(this);
        LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        linearLayout.setOrientation(LinearLayout.VERTICAL);
        linearLayout.setLayoutParams(linearParams);

        /*
        RELLENA EL SCROLL DEL EQUIPO 1 CON EL LAYOUT DE BOTON JUGADOR
         */
        scrollView.addView(linearLayout);
        int contador = 0;
        for (Jugador e : equipo1.getJugadores()) {
            LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            params1.setMargins(0, 10, 0, 10);
            params1.gravity = Gravity.CENTER;
            LayoutInflater inflater = (LayoutInflater) getSystemService(LAYOUT_INFLATER_SERVICE);
            View itemBox;
            itemBox = inflater.inflate(R.layout.botonjugador, null);
            itemBox.setLayoutParams(params1);
            ImageView iv = (ImageView)itemBox.findViewById(R.id.dorsal);
            setCamiseta(iv, e.getDorsal(), e.esTitular);
            String stringTitular="suplente";
            if(e.esTitular){
                stringTitular="titular";
            }
            String stringEquipo = String.valueOf(Equipo.GetEquipoJugador(e).getID());
            iv.setTag(String.valueOf(e.getDorsal())+"-"+stringTitular+"-"+stringEquipo);
            itemBox.setTag(contador);
            contador++;
            itemBox.setOnLongClickListener(listenClick);
            itemBox.setOnDragListener(listenDrag);
            linearLayout.addView(itemBox);
            if(e.esTitular==false){
                disable((ViewGroup) itemBox);
            }
        }

        LinearLayout linearLayout1 = findViewById(R.id.scrollLayout1);
        if (linearLayout1 != null) {
            linearLayout1.addView(scrollView);
        }

        /*
        PARÁMETROS PARA EL SCROLL DEL EQUIPO 2
         */

        ScrollView scrollView2 = new ScrollView(this);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        scrollView2.setLayoutParams(layoutParams2);

        LinearLayout linearLayout2 = new LinearLayout(this);
        LinearLayout.LayoutParams linearParams2 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        linearLayout2.setOrientation(LinearLayout.VERTICAL);
        linearLayout2.setLayoutParams(linearParams2);

        /*
        RELLENA EL SCROLL DEL EQUIPO 2 CON EL LAYOUT DE BOTON JUGADOR
         */

        scrollView2.addView(linearLayout2);
        contador = 0;
        for (Jugador e : equipo2.getJugadores()) {
            LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            params2.setMargins(0, 10, 0, 10);
            params2.gravity = Gravity.CENTER;
            LayoutInflater inflater = (LayoutInflater) getSystemService(LAYOUT_INFLATER_SERVICE);
            View itemBox;
            itemBox = inflater.inflate(R.layout.botonjugador2, null);
            itemBox.setLayoutParams(params2);
            ImageView iv = (ImageView)itemBox.findViewById(R.id.dorsal);
            setCamiseta(iv, e.getDorsal(), e.esTitular);
            String stringTitular="suplente";
            if(e.esTitular){
                stringTitular="titular";
            }
            String stringEquipo = String.valueOf(Equipo.GetEquipoJugador(e).getID());
            iv.setTag(String.valueOf(e.getDorsal())+"-"+stringTitular+"-"+stringEquipo);
            itemBox.setTag(contador);
            contador++;
            itemBox.setOnLongClickListener(listenClick);
            itemBox.setOnDragListener(listenDrag);
            linearLayout2.addView(itemBox);
            if(e.esTitular==false){
                disable((ViewGroup) itemBox);
            }
        }

        LinearLayout linearLayout3 = findViewById(R.id.scrollLayout2);
        if (linearLayout3 != null) {
            linearLayout3.addView(scrollView2);
        }

        Typeface customFont = Typeface.createFromAsset(getAssets(), "fonts/digital7.ttf");
        TextView tagEquipo1 = findViewById(R.id.tagEquipo1);
        TextView tagEquipo2 = findViewById(R.id.tagEquipo2);
        TextView marcador1 = findViewById(R.id.marcadorEq1);
        TextView marcador2 = findViewById(R.id.marcadorEq2);
        TextView contadorPartesView = findViewById(R.id.contadorPartesVIew);
        TextView tiempoMuertoView1 = findViewById(R.id.tiempoMuertoView1);
        tiempoMuertoView1.setText("TM" + System.getProperty ("line.separator") + System.getProperty ("line.separator")+ "0");
        tiempoMuertoView1.setTypeface(customFont);
        TextView tiempoMuertoView2 = findViewById(R.id.tiempoMuertoView2);
        tiempoMuertoView2.setText("TM" + System.getProperty ("line.separator") + System.getProperty ("line.separator") +"0");
        tiempoMuertoView2.setTypeface(customFont);
        contadorPartesView.setTypeface(customFont);
        contadorPartesView.setText(String.valueOf(GlobalVars.CONT_PARTS));

        tagEquipo1.setText(equipo1.getNombreEquipo());
        tagEquipo2.setText(equipo2.getNombreEquipo());
        marcador1.setText("00");
        marcador2.setText("00");
        marcador1.setTypeface(customFont);
        marcador2.setTypeface(customFont);






        findViewById(R.id.restaMarcadorEq1).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v)
            {
                sumaGol(findViewById(R.id.marcadorEq1), -1);
            }
        });


        findViewById(R.id.restaMarcadorEq2).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v)
            {
                sumaGol(findViewById(R.id.marcadorEq2), -1);
            }
        });

        ImageButton resumenButton = findViewById(R.id.resumenButton);
        resumenButton.setBackgroundColor(Color.TRANSPARENT);
        resumenButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(GameTime.this, MatchActivity.class);
                startActivityForResult(intent,0);
            }
        });

        cronoViewModel = new CronoViewModel(this, this);
        jugadoresViewModel = new JugadoresViewModel();


        try {
            StopwatchWrapper.SubscribirOnFinish(this, GameTime.class.getDeclaredMethod("mostrarFinal"));
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    View.OnLongClickListener listenClick = new View.OnLongClickListener()
    {
        @Override
        public boolean onLongClick(View v)
        {
            ClipData data = ClipData.newPlainText("","");
            View.DragShadowBuilder shadowBuilder = new View.DragShadowBuilder(v);

            v.startDrag(data, shadowBuilder, v, 0);

            return false;
        }
    };

    View.OnDragListener listenDrag = new View.OnDragListener() {

        @Override
        public boolean onDrag(View v, DragEvent event)
        {
            int dragEvent = event.getAction();

            switch (dragEvent)
            {
                case DragEvent.ACTION_DRAG_ENTERED:
                    break;

                case DragEvent.ACTION_DRAG_EXITED:
                    break;

                case DragEvent.ACTION_DROP:

                    LinearLayout viewBeingHold = (LinearLayout) event.getLocalState();
                    LinearLayout owner = (LinearLayout) viewBeingHold.getParent();

                    owner.removeView(viewBeingHold);

                    LinearLayout containerWhereViewWillBeDropped = (LinearLayout) v.getParent();

                    viewBeingHold.setVisibility(View.VISIBLE);

                    LinearLayout viewAlreadyOnLayout = (LinearLayout) v;

                    if (viewAlreadyOnLayout != null) {

                        ImageView imageviewCampo = null;
                        String dorsalCampo = "";
                        String stringCampo = "";
                        String stringEquipo = "";
                        for (int itemPos = 0; itemPos < viewBeingHold.getChildCount(); itemPos++) {
                            View view = viewBeingHold.getChildAt(itemPos);
                            if (view instanceof ImageView) {
                                imageviewCampo = (ImageView) view;
                                dorsalCampo = (String) imageviewCampo.getTag();
                                String[] splitCampo = dorsalCampo.split("-");
                                dorsalCampo = splitCampo[0];
                                stringCampo = splitCampo[1];
                                stringEquipo = splitCampo[2];
                            }
                        }

                        ImageView imageviewSuplente = null;
                        String dorsalSuplente = "";
                        String stringSuplente = "";
                        String stringEquipoS = "";
                        for (int itemPos = 0; itemPos < viewAlreadyOnLayout.getChildCount(); itemPos++) {
                            View view = viewAlreadyOnLayout.getChildAt(itemPos);
                            if (view instanceof ImageView) {
                                imageviewSuplente = (ImageView) view;
                                dorsalSuplente = (String) imageviewSuplente.getTag();
                                String[] splitSuplente = dorsalSuplente.split("-");
                                dorsalSuplente = splitSuplente[0];
                                stringSuplente = splitSuplente[1];
                                stringEquipoS = splitSuplente[2];
                            }
                        }

                        if(Integer.parseInt(stringEquipo) != Integer.parseInt(stringEquipoS)){
                            LinearLayout auxTit = (LinearLayout) viewBeingHold;
                            int indexTit = (int) auxTit.getTag();
                            owner.addView(viewBeingHold, indexTit);
                            break;
                        }

                        Equipo equipoObjetivo;
                        if(Integer.parseInt(stringEquipo) == 1){
                            equipoObjetivo = equipo1;
                        } else {
                            equipoObjetivo = equipo2;
                        }

                        Jugador jc = equipoObjetivo.selJugador(Integer.parseInt(dorsalCampo));
                        Jugador js = equipoObjetivo.selJugador(Integer.parseInt(dorsalSuplente));

                        Log.d("es titular campo", String.valueOf(jc.getEsTitular()));
                        Log.d("es titular suplente", String.valueOf(js.getEsTitular()));

                        if(!jc.getExclusion()){
                            if(jc.getEsTitular() && !js.getEsTitular()) {

                                LinearLayout auxTit = (LinearLayout) viewBeingHold;
                                int indexTit = (int) auxTit.getTag();

                                LinearLayout aux = (LinearLayout) viewAlreadyOnLayout;
                                int indexSup = (int) aux.getTag();
                                int expulsados = equipoObjetivo.getExpulsados();
                                js.setEsTitular(true);
                                jc.setEsTitular(false);
                                containerWhereViewWillBeDropped.removeView(viewAlreadyOnLayout);
                                containerWhereViewWillBeDropped.addView(viewBeingHold, indexSup - 1 - expulsados);
                                owner.addView(viewAlreadyOnLayout, indexTit);
                                viewAlreadyOnLayout.setTag(indexTit);
                                viewBeingHold.setTag(indexSup);
                                enable(viewAlreadyOnLayout);
                                disable(viewBeingHold);
                                DBManager.guardarEvento(jc.getDorsal(), equipoObjetivo.getNombreEquipo(), "sustitucion", stringCampo, js.getDorsal(), stringSuplente, cronoViewModel.getTiempoRestanteMs());
                            } else{
                                LinearLayout auxTit = (LinearLayout) viewBeingHold;
                                int indexTit = (int) auxTit.getTag();
                                owner.addView(viewBeingHold, indexTit);
                            }
                        } else {
                            LinearLayout auxTit = (LinearLayout) viewBeingHold;
                            int indexTit = (int) auxTit.getTag();
                            owner.addView(viewBeingHold, indexTit);
                        }
                    }
                    break;
                case DragEvent.ACTION_DRAG_LOCATION:

                    ScrollView mainScrollView = (ScrollView) v.getParent().getParent().getParent().getParent();

                    int topOfDropZone = v.getTop();
                    int bottomOfDropZone = v.getBottom();

                    int scrollY = mainScrollView.getScrollY();
                    int scrollViewHeight = mainScrollView.getMeasuredHeight();

                    if (bottomOfDropZone > (scrollY + scrollViewHeight - 100))
                        mainScrollView.smoothScrollBy(0, 30);

                    if (topOfDropZone < (scrollY + 100))
                        mainScrollView.smoothScrollBy(0, -30);
                    break;
            }
            return true;
        }
    };

    public static void disable(ViewGroup layout){
        for (int i = 0; i < layout.getChildCount(); i++) {
            View child = layout.getChildAt(i);
            if (child instanceof ViewGroup) {
                disable((ViewGroup) child);
            } else {
                child.setEnabled(false);
            }
        }
    }

    public static void enable(ViewGroup layout){
        for (int i = 0; i < layout.getChildCount(); i++) {
            View child = layout.getChildAt(i);
            if (child instanceof ViewGroup) {
                enable((ViewGroup) child);
            } else {
                child.setEnabled(true);
            }
        }
    }

    public static void setCamiseta(ImageView imageview, int dorsal, boolean esTitular) {
        int id = ResourceIDsManager.GetIDCamiseta(esTitular, dorsal);
        imageview.setImageResource(id);
    }

    public void mostrarFinal(){
        View v = findViewById(R.id.playgame);
        v.setVisibility(View.INVISIBLE);
        LayoutInflater inflater = (LayoutInflater)
                getSystemService(LAYOUT_INFLATER_SERVICE);
        Context context = getApplicationContext();
        View popupView = inflater.inflate(R.layout.final_layout, null);
        LinearLayout linearLayout = new LinearLayout(context);
        LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        linearLayout.setOrientation(LinearLayout.HORIZONTAL);
        linearLayout.setLayoutParams(linearParams);
        // create the popup window
        int width = LinearLayout.LayoutParams.WRAP_CONTENT;
        int height = LinearLayout.LayoutParams.WRAP_CONTENT;
        boolean focusable = true; // lets taps outside the popup also dismiss it
        final PopupWindow popupWindow = new PopupWindow(popupView, width, height, focusable);
        ((TextView) popupWindow.getContentView().findViewById(R.id.contadorPartesVIew)).setText(String.valueOf(GlobalVars.CONT_PARTS));
        ((TextView) popupWindow.getContentView().findViewById(R.id.contadorPartesVIew)).setTypeface(customFont);
        ((TextView) popupWindow.getContentView().findViewById(R.id.marcadorEq1)).setText(String.valueOf(equipo1.getGoles()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.marcadorEq1)).setTypeface(customFont);
        ((TextView) popupWindow.getContentView().findViewById(R.id.marcadorEq2)).setText(String.valueOf(equipo2.getGoles()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.marcadorEq2)).setTypeface(customFont);
        ((TextView) popupWindow.getContentView().findViewById(R.id.tiempoMuertoView1)).setText("TM" + System.getProperty ("line.separator") + System.getProperty ("line.separator") +String.valueOf(equipo1.gettMuerto()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.tiempoMuertoView1)).setTypeface(customFont);
        ((TextView) popupWindow.getContentView().findViewById(R.id.tiempoMuertoView2)).setText("TM" + System.getProperty ("line.separator") + System.getProperty ("line.separator")+ equipo2.gettMuerto());
        ((TextView) popupWindow.getContentView().findViewById(R.id.tiempoMuertoView2)).setTypeface(customFont);
        ((TextView) popupWindow.getContentView().findViewById(R.id.temporizador)).setText("00:00");
        ((TextView) popupWindow.getContentView().findViewById(R.id.temporizador)).setTypeface(customFont);
        String resultadoFinal = "";
        if(Partido.GetInstance().getPartes()==GlobalVars.CONT_PARTS) {
            findViewById(R.id.reiniciarCrono).setVisibility(View.INVISIBLE);
            if (equipo1.getGoles() > equipo2.getGoles()) {
                resultadoFinal = "¡FINAL! " + equipo1.getNombreEquipo() + " se lleva la victoria por " + (equipo1.getGoles() - equipo2.getGoles()) + " goles a favor.";
            } else if (equipo2.getGoles() > equipo1.getGoles()) {
                resultadoFinal = "¡FINAL! " + equipo2.getNombreEquipo() + " se lleva la victoria por " + (equipo2.getGoles() - equipo1.getGoles()) + " goles a favor.";
            } else {
                resultadoFinal = "¡FINAL! Ninguno de los dos logra llevarse la victoria " + equipo1.getNombreEquipo() + " empatan con " + equipo2.getNombreEquipo() + " a " + equipo1.getGoles() + " goles.";
            }
        } else{
            String cardinal = "";
            if(GlobalVars.CONT_PARTS==1){
                cardinal = "primera";
            } else if(GlobalVars.CONT_PARTS==2){
                cardinal = "segunda";
            } else if(GlobalVars.CONT_PARTS==3){
                cardinal = "tercera";
            }
            if (equipo1.getGoles() > equipo2.getGoles()) {
                resultadoFinal = "¡DESCANSO! " + equipo1.getNombreEquipo() + " se lleva la victoria al final de la "+ cardinal + " parte. Con " + (equipo1.getGoles() - equipo2.getGoles()) + " goles a favor.";
            } else if (equipo2.getGoles() > equipo1.getGoles()) {
                resultadoFinal = "¡DESCANSO! " + equipo2.getNombreEquipo() + " se lleva la victoria  al final de la "+ cardinal + " parte. Con " + (equipo2.getGoles() - equipo1.getGoles()) + " goles a favor.";
            } else {
                resultadoFinal = "¡DESCANSO! Ninguno de los dos logra llevarse la victoria al final de la "+ cardinal + " parte." + equipo1.getNombreEquipo() + " empatan con " + equipo2.getNombreEquipo() + " a " + equipo1.getGoles() + " goles.";
            }
        }
        GlobalVars.CONT_PARTS++;

        ((TextView) popupWindow.getContentView().findViewById(R.id.resultadoFinalLabel)).setText(resultadoFinal);
        popupWindow.showAtLocation(v, Gravity.CENTER, 0, 0);
    }

    public void sumaGol(View v) {
        actualizarItem(v, "marcador");
    }

    public void sumaGol(View v, int i) {
        actualizarItem(v, "marcador", i);
    }

    public void sumaGolJugador(View v) {
        actualizarItem(v, "gol");
    }

    public void sumaGolJugador(View v, int i) {
        actualizarItem(v, "gol", i);
    }

    public void sumaTiro(View v){
        actualizarItem(v, "tiro");
    }

    public void sumaFalta(View v){
        actualizarItem(v, "falta");
    }

    public void sumaRecuperacion(View v){
        actualizarItem(v, "recuperacion");
    }

    public void sumaAmarilla(View v){
        actualizarItem(v,"amarilla");
    }

    public void addRoja(View v){
        actualizarItem(v,"tRoja");
    }


    private void exclusion(View v) {
        actualizarItem(v, "exclusion");
    }

    /*
     * Actualiza la vista desde el botón(textview) de la tabla generada
     */

    public void actualizarItem(View v, String caso){
        ViewParent vista = v.getParent().getParent().getParent().getParent().getParent().getParent();
        int vistaId = ((View) vista).getId();
        if(vistaId == R.id.scrollLayout1  || v.getId()==R.id.marcadorEq1) {
            upsertJugador(v, caso, 1, 1);
        } else {
            upsertJugador(v,caso,2, 1);
        }
    }

    public void actualizarItem(View v, String caso, int i){
        ViewParent vista = v.getParent().getParent().getParent().getParent().getParent().getParent();
        int vistaId = ((View) vista).getId();
        if(vistaId == R.id.scrollLayout1  || v.getId()==R.id.marcadorEq1) {
            upsertJugador(v, caso, 1, i);
        } else {
            upsertJugador(v, caso,2, i);
        }
    }

    public void upsertJugador(View v, String caso, int equipo, int evento){
        ImageView imageview = null;
        String dorsal = "";
        String stringTitular = "";
        ViewGroup row = (ViewGroup) v.getParent();
        ViewGroup grandParent = (ViewGroup) row.getParent().getParent();
        for (int itemPos = 0; itemPos < grandParent.getChildCount(); itemPos++) {
            View view = grandParent.getChildAt(itemPos);
            if (view instanceof ImageView) {
                imageview = (ImageView) view;
                dorsal = (String) imageview.getTag();
                String[] split = dorsal.split("-");
                dorsal = split[0];
                stringTitular = split[1];
            }
        }

        Equipo equipoObjetivo = equipo == 1 ? equipo1 : equipo2;
        Jugador j = null;
        if(caso!="marcador"){
            j = equipoObjetivo.selJugador(Integer.parseInt(dorsal));
        }
        switch(caso){
            case "gol":
                    if (evento == 1) {
                        jugadoresViewModel.AñadirGolJugador(j, v, cronoViewModel.getTiempoRestanteMs());
                    } else {
                        jugadoresViewModel.RestarGolJugador(j);
                    }
                break;
            case "tiro":
                    jugadoresViewModel.AñadirTiroJugador(j, v, cronoViewModel.getTiempoRestanteMs());
                break;
            case "amarilla":
                    equipoObjetivo.setAmarilla(1);
                    if(equipoObjetivo.getAmarillas()>3){
                        exclusion(v);
                        equipoObjetivo.setAmarilla(-1);
                    } else {
                        j.setAmarillas(1);
                        j = equipoObjetivo.selJugador(Integer.parseInt(dorsal));
                        if(j.getAmarillas()==2){
                            exclusion(v);
                        }
                        DBManager.guardarEvento(Integer.parseInt(dorsal), equipoObjetivo.getNombreEquipo(), "amarilla", stringTitular, cronoViewModel.getTiempoRestanteMs());
                        DBManager.guardarEquipo(equipoObjetivo, "equipo" + equipo);
                    }
                break;
            case "falta":
                    jugadoresViewModel.AñadirFaltaJugador(j, v, cronoViewModel.getTiempoRestanteMs());
                break;
            case "recuperacion":
                    jugadoresViewModel.AñadirRecuJugador(j, v, cronoViewModel.getTiempoRestanteMs());
                break;
            case "tRoja":
                    cronoViewModel.AddTarjetaRojaJugador(j, v);
                    DBManager.guardarEvento(Integer.parseInt(dorsal), equipoObjetivo.getNombreEquipo(), "tRoja", stringTitular, cronoViewModel.getTiempoRestanteMs());
                    DBManager.guardarEquipo(equipoObjetivo, "equipo" + equipo);
                break;
            case "exclusion":
                    cronoViewModel.AddJugadorExcluido(j, v);
                    DBManager.guardarEvento(Integer.parseInt(dorsal), equipoObjetivo.getNombreEquipo(), "exclu",stringTitular, cronoViewModel.getTiempoRestanteMs());
                    DBManager.guardarEquipo(equipoObjetivo, "equipo" + equipo);
                break;
            case "marcador":
                    if(evento == 1) {
                        jugadoresViewModel.AñadirGolEquipo(equipoObjetivo);
                    } else {
                        jugadoresViewModel.RestarGolEquipo(equipoObjetivo);
                    }
                break;
        }
    }

    /*
    ACTUALIZA EL MARCADOR Y LOS DISTINTOS DATOS DE LOS JUGADORES.
     */

    public static void actualizarVista(View v) {
        TextView caja = (TextView) v;
        String resultado = caja.getText().toString();
        resultado = resultado.replace( "\n", "" );
        resultado = resultado.replace( " ", "" );
        Integer dato = Integer.parseInt(resultado) + 1;
        String string = dato.toString();
        if (dato < 10) {
            string = "0" + string;
        }
        caja.setText(string);
    }


    public static void actualizarVista(View v, int i) {
        TextView caja = (TextView) v;
        String resultado = caja.getText().toString();
        resultado = resultado.replace( "\n", "" );
        resultado = resultado.replace( " ", "" );
        Integer dato = Integer.parseInt(resultado) + i;
        if(dato>=0) {
            String string = dato.toString();
            if (dato < 10) {
                string = "0" + string;
            }
            caja.setText(string);
        }
    }

    //Gestión del botón atrás en esta actividad.
    @Override
    public void onBackPressed() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("SALIR");
        builder.setMessage("¿Desea cerrar el partido actual?");
        builder.setPositiveButton("Sí", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                atras = true;
                irAtras(atras);

            }
        });
        builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                atras = false;
            }
        });
        builder.create();
        builder.show();
    }

    public void irAtras(boolean atras){
        if(atras==true){
            super.onBackPressed();
        }
    }

    public void abrirMenuJugadorEquipo(View view) {

        // inflate the layout of the popup window
        LayoutInflater inflater = (LayoutInflater)
                getSystemService(LAYOUT_INFLATER_SERVICE);
        View popupView = inflater.inflate(R.layout.menu_jugador, null);

        // create the popup window
        int width = LinearLayout.LayoutParams.WRAP_CONTENT;
        int height = LinearLayout.LayoutParams.WRAP_CONTENT;
        boolean focusable = true; // lets taps outside the popup also dismiss it
        final PopupWindow popupWindow = new PopupWindow(popupView, width, height, focusable);
        View scroll = (View) view.getParent().getParent().getParent().getParent();
        Equipo equipoObjetivo;
        if(scroll.getId()==R.id.scrollLayout1){
            equipoObjetivo = equipo1;
        } else{
            equipoObjetivo = equipo2;
        }

        String dorsal = (String) view.getTag();
        String[] split = dorsal.split("-");
        dorsal = split[0];
        Jugador j = equipoObjetivo.selJugador(Integer.parseInt(dorsal));
        ((TextView) popupWindow.getContentView().findViewById(R.id.penaltiView)).setText(String.valueOf(j.getLanzaPenalty()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.excluView)).setText(String.valueOf(j.getNumExclusiones()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.golView)).setText(String.valueOf(j.getGoles()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.recuView)).setText(String.valueOf(j.getRecuperaciones()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.tiroView)).setText(String.valueOf(j.getTiro()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.faltaView)).setText(String.valueOf(j.getFaltas()));
        ((TextView) popupWindow.getContentView().findViewById(R.id.tAmarillaView)).setText(String.valueOf(j.getAmarillas()));

        ImageButton penalti =((ImageButton) popupWindow.getContentView().findViewById(R.id.penaltipopup));
        penalti.setBackgroundColor(Color.TRANSPARENT);
        penalti.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    j.setLanzaPenalty(1);
                    String titular = "suplente";
                    if (j.getEsInicial()) {
                        titular = "titular";
                    }
                    DBManager.guardarEvento(j.getDorsal(), equipoObjetivo.getNombreEquipo(), "penalty", titular, cronoViewModel.getTiempoRestanteMs());
                }
                popupWindow.dismiss();
            }
        });
        ImageButton exclusion =((ImageButton) popupWindow.getContentView().findViewById(R.id.exclupopup));
        exclusion.setBackgroundColor(Color.TRANSPARENT);
        exclusion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "exclusion");
                }
                popupWindow.dismiss();
            }
        });
        ImageButton tRoja =((ImageButton) popupWindow.getContentView().findViewById(R.id.tRojapopup));
        tRoja.setBackgroundColor(Color.TRANSPARENT);
        tRoja.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "tRoja");
                }
                popupWindow.dismiss();
            }
        });
        ImageButton gol =((ImageButton) popupWindow.getContentView().findViewById(R.id.golpopup));
        gol.setBackgroundColor(Color.TRANSPARENT);
        gol.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "gol");
                }
                popupWindow.dismiss();
            }
        });
        ImageButton recuperacion =((ImageButton) popupWindow.getContentView().findViewById(R.id.recuperacionpopup));
        recuperacion.setBackgroundColor(Color.TRANSPARENT);
        recuperacion.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "recuperacion");
                }
                popupWindow.dismiss();
            }
        });
        ImageButton tiro =((ImageButton) popupWindow.getContentView().findViewById(R.id.tiropopup));
        tiro.setBackgroundColor(Color.TRANSPARENT);
        tiro.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "tiro");
                }
                popupWindow.dismiss();
            }
        });
        ImageButton falta =((ImageButton) popupWindow.getContentView().findViewById(R.id.faltapopup));
        falta.setBackgroundColor(Color.TRANSPARENT);
        falta.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "falta");
                }
                popupWindow.dismiss();
            }
        });
        ImageButton tAmarilla =((ImageButton) popupWindow.getContentView().findViewById(R.id.tAmarillapopup));
        tAmarilla.setBackgroundColor(Color.TRANSPARENT);
        tAmarilla.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "tAmarilla");
                }
                popupWindow.dismiss();
            }
        });
        ImageButton anularGol =((ImageButton) popupWindow.getContentView().findViewById(R.id.anularpopup));
        anularGol.setBackgroundColor(Color.TRANSPARENT);
        anularGol.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!j.getExclusion() && !j.getRoja()) {
                    actualizarDesdeMenu(view, "anularGol");
                    popupWindow.dismiss();
                }
            }
        });

        // show the popup window
        // which view you pass in doesn't matter, it is only used for the window tolken
        popupWindow.showAtLocation(view, Gravity.CENTER, 0, 0);

        // dismiss the popup window when touched
        popupView.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                popupWindow.dismiss();
                return true;
            }
        });
    }

    private void actualizarDesdeMenu(View view, String caso) {
        int id;
        switch (caso){
            case"gol":
            case"anularGol":
                id = R.id.golesLabel;
                break;
            case"tiro":
                id = R.id.tirosLabel;
                break;
            case"recuperacion":
                id = R.id.recuperacionesLabel;
                break;
            case"falta":
                id = R.id.faltasLabel;
                break;
            default:
                id = R.id.recuperacionesLabel;
        }
        ViewGroup row = (ViewGroup) view.getParent();
        for (int itemPos = 0; itemPos < row.getChildCount(); itemPos++) {
            View vi = (View) row.getChildAt(itemPos);
            if (vi instanceof TableLayout) {
                TableLayout table = (TableLayout) vi;
                for (int itemTable = 0; itemTable<=table.getChildCount();itemTable++){
                    View t =  table.getChildAt(itemTable);
                    if(t.getId()==R.id.Labelsrow){
                        TableRow tRow = (TableRow) t;
                        for(int rowTable= 0; rowTable<=tRow.getChildCount();rowTable++){
                            View label = tRow.getChildAt(rowTable);
                            if(label.getId()==id){
                                switch (caso){
                                    case"gol":
                                        sumaGolJugador(label, 1);
                                        break;
                                    case"tiro":
                                        sumaTiro(label);
                                        break;
                                    case"recuperacion":
                                        sumaRecuperacion(label);
                                        break;
                                    case"falta":
                                        sumaFalta(label);
                                        break;
                                    case"tAmarilla":
                                        sumaAmarilla(label);
                                        break;
                                    case"exclusion":
                                        exclusion(label);
                                        break;
                                    case"anularGol":
                                        sumaGolJugador(label, -1);
                                        break;
                                    case"tRoja":
                                        addRoja(label);
                                        break;

                                }
                                break; // CIERRO EL BUCLE AL ACTUALIZAR EL ITEM
                            }
                        }
                        break; // SALGO DEL BUCLE AL ENCONTRAR LA TABLA
                    }
                }
            }
        }
    }
}