package com.miapp.handbappscore;

import java.util.ArrayList;
import java.util.List;

public class Equipo{

    private static List<Equipo> equipos = new ArrayList<>();

    public String nombreEquipo;
    public ArrayList<Jugador> jugadores;
    public int goles;
    public int tMuerto;
    public int tAmarilla;
    public int ID;

    public Equipo(int id) {
        this.nombreEquipo = "";
        this.jugadores = new ArrayList<Jugador>();
        this.goles = 0;
        this.tMuerto = 0;
        this.tAmarilla = 0;
        this.ID = id;

        equipos.add(this);
    }

    public static Equipo GetEquipoJugador(Jugador jugador) {
        for (Equipo equipo : equipos) {
            for (Jugador jugadorEquipo: equipo.getJugadores()) {
                if (jugador.equals(jugadorEquipo)) {
                    return equipo;
                }
            }
        }

        return null;
    }

    public static Equipo getEquipo(int numeroEquipo) { return equipos.get(numeroEquipo); }

    public int getID() { return ID; }

    public void setJugadores(ArrayList<Jugador> jugadores) {
        this.jugadores = jugadores;
    }

    public ArrayList<Jugador> getJugadores() {
        return this.jugadores;
    }

    public void setNombreEquipo(String nombreEquipo) {
        this.nombreEquipo = nombreEquipo;
    }

    public String getNombreEquipo() {
        return this.nombreEquipo;
    }

    public void setGoles(int i) {
        this.goles = this.goles + i;
    }

    public void setAmarilla(int i){
        this.tAmarilla = this.tAmarilla+i;
    }

    public int getAmarillas() {
        return this.tAmarilla;
    }

    public void setTiempoMuerto(int tm){
        this.tMuerto = this.tMuerto +tm;
    }

    public int gettMuerto(){
        return this.tMuerto;
    }

    public int getGoles(){ return this.goles;}

    public static int GetNumeroMaximoEquipos(){
        return 2;
    }

    public Jugador selJugador(int dorsal){
        Jugador piti = null;
        for(Jugador j : this.jugadores){
            if(j.getDorsal()==dorsal){
                piti = j;
            }
        }
        return piti;
    }

    public int getExcluidos(){
        int contExcluidos = 0;
        for(Jugador j:this.jugadores){
            if(j.getExclusion()){
                contExcluidos++;
            }
        }
        return contExcluidos;
    }

    public List<Jugador> getSuplentes() {
        List<Jugador> suplentes = new ArrayList<>();
        for (Jugador jugador : jugadores) {
            if (!jugador.getEsTitular()) {
                suplentes.add(jugador);
            }
        }

        return suplentes;
    }

    public int getExpulsados() {
        int contExpulsados = 0;
        for(Jugador j : jugadores){
            if(j.getRoja()){
                contExpulsados++;
            }
        }
        return contExpulsados;
    }

    public static Equipo getEquipoByName(String nombreEquipo){
        for(Equipo equipo : equipos) {
            if(equipo.getNombreEquipo().equals(nombreEquipo)){
                return equipo;
            }

        }
        return null;
    }
}

