package com.miapp.handbappscore;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class DBManager {
    private static List<Estadistica> eventos = new ArrayList<Estadistica>();
    private static Context appContext;

    public static void CreateDB(Equipo equipo1, Equipo equipo2, Context context) {
        appContext = context;
        MatchDB conn=new MatchDB(appContext,"bd_partidos",null,1);
        String[] parametros={String.valueOf(GlobalVars.IDRESULTANTE)};
        SQLiteDatabase db=conn.getReadableDatabase();
        try{
            Cursor cursor =db.query(GlobalVars.TABLA_PARTIDO, new String[]{"equipo1, equipo2"},"_id=?",parametros,null,null,null);
            cursor.moveToFirst();
            String storedEquipo1String = cursor.getString(0);
            String storedEquipo2String = cursor.getString(1);
            Gson gson = new Gson();
            equipo1 = gson.fromJson(storedEquipo1String, Equipo.class);
            equipo2 = gson.fromJson(storedEquipo2String, Equipo.class);
            cursor.close();
        } catch (Exception e){
            Log.d("EL equipo no existe","todavía");
        }

        parametros= new String[]{String.valueOf(GlobalVars.IDRESULTANTE)};
        String[] campos={"partes","duracion","numTitulares"};

        try {
            Cursor cursor =db.query(GlobalVars.TABLA_PARTIDO,campos,"_id=?",parametros,null,null,null);
            cursor.moveToFirst();
            GlobalVars.NUM_PARTS = cursor.getInt(0);
            Partido.GetInstance().setPartes(GlobalVars.NUM_PARTS);
            GlobalVars.MATCH_TIME = cursor.getInt(1);
            Partido.GetInstance().setDuracion(GlobalVars.MATCH_TIME);
            GlobalVars.MAX_TIT = cursor.getInt(2);
            Partido.GetInstance().setNumTitulares(GlobalVars.MAX_TIT);
            cursor.close();
        }catch (Exception e){
            Log.d("EL documento no existe","todavía");
        }
    }

    public static void guardarEvento(String NomEquipo, String caso, long tiempoMilisegundos) {
        int mins = (int) tiempoMilisegundos / 60000;
        int seg = (int) tiempoMilisegundos % 60000 / 1000;
        Estadistica evento = new Estadistica();
        evento.setEvento(caso);
        evento.setMinuto(mins);
        evento.setSegundos(seg);
        evento.setNombreEq(NomEquipo);
        eventos.add(evento);
        MatchDB conn = new MatchDB(appContext, "bd_partidos", null, 1);
        SQLiteDatabase db = conn.getWritableDatabase();
        String[] parametros = {String.valueOf(GlobalVars.IDRESULTANTE)};
        ContentValues values = new ContentValues();
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Estadistica>>(){}.getType();
        String toStoreObject = gson.toJson(eventos, listType);
        values.put("estadistica", toStoreObject);
        db.update(GlobalVars.TABLA_PARTIDO, values, "_id=?", parametros);
        db.close();
    }

    public static void guardarEvento(int dorsal, String NomEquipo, String caso, String titular, long tiempoMilisegundos) {
        int mins = (int) tiempoMilisegundos / 60000;
        int seg = (int) tiempoMilisegundos % 60000 / 1000;
        Estadistica evento = new Estadistica();
        evento.setEvento(caso);
        evento.setTitular(titular);
        evento.setDorsalJugador(dorsal);
        evento.setMinuto(mins);
        evento.setSegundos(seg);
        evento.setNombreEq(NomEquipo);
        eventos.add(evento);
        MatchDB conn = new MatchDB(appContext, "bd_partidos", null, 1);
        SQLiteDatabase db = conn.getWritableDatabase();
        String[] parametros = {String.valueOf(GlobalVars.IDRESULTANTE)};
        ContentValues values = new ContentValues();
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Estadistica>>(){}.getType();
        String toStoreObject = gson.toJson(eventos, listType);
        values.put("estadistica", toStoreObject);
        db.update(GlobalVars.TABLA_PARTIDO, values, "_id=?", parametros);
        db.close();
    }


    public static void guardarEvento(int dorsal, String NomEquipo, String caso, String titular, int dorsalSuplente, String suplente, long tiempoMilisegundos) {
        int mins = (int) tiempoMilisegundos / 60000;
        int seg = (int) tiempoMilisegundos % 60000 / 1000;
        Estadistica evento = new Estadistica();
        evento.setEvento(caso);
        evento.setTitular(titular);
        evento.setDorsalJugador(dorsal);
        evento.setMinuto(mins);
        evento.setSegundos(seg);
        evento.setNombreEq(NomEquipo);
        evento.setDorsalSuplente(dorsalSuplente);
        evento.setSuplente(suplente);
        eventos.add(evento);
        MatchDB conn = new MatchDB(appContext, "bd_partidos", null, 1);
        SQLiteDatabase db = conn.getWritableDatabase();
        String[] parametros = {String.valueOf(GlobalVars.IDRESULTANTE)};
        ContentValues values = new ContentValues();
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Estadistica>>(){}.getType();
        String toStoreObject = gson.toJson(eventos, listType);
        values.put("estadistica", toStoreObject);
        db.update(GlobalVars.TABLA_PARTIDO, values, "_id=?", parametros);
        db.close();
    }

    public static void guardarEquipo(Equipo equipo, String stringEquipo) {
        MatchDB conn = new MatchDB(appContext, "bd_partidos", null, 1);
        SQLiteDatabase db = conn.getWritableDatabase();
        String[] parametros = {String.valueOf(GlobalVars.IDRESULTANTE)};
        ContentValues values = new ContentValues();
        Gson gson = new Gson();
        String toStoreObject = gson.toJson(equipo, Equipo.class);
        values.put(stringEquipo, toStoreObject);
        db.update(GlobalVars.TABLA_PARTIDO, values, "_id=?", parametros);
        db.close();
    }
}
