package com.miapp.handbappscore;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.miapp.handbappscore.comandos.AñadirGolEquipoComando;
import com.miapp.handbappscore.comandos.ExcluirJugadorComando;
import com.miapp.handbappscore.comandos.IComando;
import com.miapp.handbappscore.comandos.TarjetaRojaComando;

import java.util.ArrayList;
import java.util.List;

public class CronoViewModel extends AppCompatActivity {

    private static final List<IComando> comandos = new ArrayList<>();

    private final Typeface customFont;
    private final Button countdownboton;
    private final TextView temporizador;

    private Periodo tiempoRestante;
    private boolean estaActivo;

    private final Context context;
    private final Activity activity;



    public CronoViewModel(Context context, Activity activity) {
        this.context = context;
        this.activity = activity;
        customFont = Typeface.createFromAsset(activity.getAssets(), "fonts/digital7.ttf");

        countdownboton = activity.findViewById(R.id.playgame);
        countdownboton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startStop();
            }
        });

        temporizador = activity.findViewById(R.id.temporizador);
        temporizador.setTypeface(customFont);
        temporizador.setText(Partido.GetInstance().getDuracion()+ ":00");

        tiempoRestante = new Periodo(Partido.GetInstance().getDuracion()*60000);

        for (int i = 1; i <= Equipo.GetNumeroMaximoEquipos(); ++i) {
            for (int j = 1; j <= ResourceIDsManager.GetNumeroDeCronosEnEquipo(i); ++j) {
                TextView crono = activity.findViewById(ResourceIDsManager.GetIDCrono(i,j));
                crono.setTypeface(customFont);
            }
        }

        activity.findViewById(R.id.reiniciarCrono).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v)
            {
                reiniciarCrono();
            }
        });

        Button tiempoMuerto1 = activity.findViewById(R.id.tiempoMuerto1);
        tiempoMuerto1.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Equipo equipo = Equipo.getEquipo(0);
                if(estaActivo) {
                    startStop();
                    equipo.setTiempoMuerto(1);
                    TextView tiempoMuertoView1 = activity.findViewById(R.id.tiempoMuertoView1);
                    tiempoMuertoView1.setTypeface(customFont);
                    tiempoMuertoView1.setText("TM" + System.getProperty ("line.separator") + System.getProperty ("line.separator") + equipo.gettMuerto());
                    DBManager.guardarEvento(equipo.getNombreEquipo(), "tiempoMuerto", getTiempoRestanteMs());
                }
            }
        });
        Button tiempoMuerto2 = activity.findViewById(R.id.tiempoMuerto2);
        tiempoMuerto2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Equipo equipo = Equipo.getEquipo(1);
                if(estaActivo) {
                    startStop();
                    equipo.setTiempoMuerto(1);
                    TextView tiempoMuertoView2 = activity.findViewById(R.id.tiempoMuertoView2);
                    tiempoMuertoView2.setTypeface(customFont);
                    tiempoMuertoView2.setText("TM" + System.getProperty ("line.separator") + System.getProperty ("line.separator") + equipo.gettMuerto() );
                    DBManager.guardarEvento(equipo.getNombreEquipo(), "tiempoMuerto", getTiempoRestanteMs());
                }
            }
        });
    }

    public void AddJugadorExcluido(Jugador jugador, View view) {
        ExcluirJugadorComando comando = new ExcluirJugadorComando(jugador, view);
        comando.Ejecutar();
        comandos.add(comando);
    }

    public void AddTarjetaRojaJugador(Jugador jugador, View view) {
        TarjetaRojaComando comando = new TarjetaRojaComando(jugador, view);
        comando.Ejecutar();
        comandos.add(comando);
    }

    public long getTiempoRestanteMs() { return tiempoRestante.getDuracionEnMs(); }

    private void startStop(){
        if(estaActivo){
            stopTime();
        } else {
            startTime();
        }
    }

    private void startTime(){
        try {
            StopwatchWrapper.SubscribirOnTick(this, CronoViewModel.class.getDeclaredMethod("onTick", long.class));
            StopwatchWrapper.SubscribirOnFinish(this, CronoViewModel.class.getDeclaredMethod("onFinish"));
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        StopwatchWrapper.Start();
        countdownboton.setText("PAUSA");
        estaActivo = true;
    }

    private void stopTime(){
        StopwatchWrapper.Stop();
        countdownboton.setText("SEGUIR");
        estaActivo = false;
    }

    private void onTick(long millisUntilFinished) {
        tiempoRestante = new Periodo(millisUntilFinished);
        temporizador.setText(tiempoRestante.ToString());
    }

    private void onFinish() {
        activity.findViewById(R.id.reiniciarCrono).setVisibility(View.VISIBLE);
        activity.findViewById(R.id.playgame).setVisibility(View.INVISIBLE);
    }

    private void reiniciarCrono() {
        tiempoRestante = new Periodo(Partido.GetInstance().getDuracion()*60000);
        temporizador.setText(tiempoRestante.ToString());
        StopwatchWrapper.SetTiempoRestanteEnMS(tiempoRestante.getDuracionEnMs());
        if(Partido.GetInstance().getPartes()==GlobalVars.CONT_PARTS-1){
            activity.findViewById(R.id.reiniciarCrono).setVisibility(View.INVISIBLE);
            activity.findViewById(R.id.playgame).setVisibility(View.INVISIBLE);
        } else {
            activity.findViewById(R.id.reiniciarCrono).setVisibility(View.INVISIBLE);
            activity.findViewById(R.id.playgame).setVisibility(View.VISIBLE);
            countdownboton.setText("SEGUIR");
            estaActivo = false;
            TextView textView = TextViewManager.findViewById(R.id.contadorPartesVIew);
            textView.setText(String.valueOf(GlobalVars.CONT_PARTS));
        }
    }


}
