package com.miapp.handbappscore;

import android.content.ContentValues;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.widget.*;
import android.view.View;
import android.os.Bundle;

public class CambiarTiempos extends AppCompatActivity {
    String[] minutos = {"30", "25", "20", "15", "10", "5"};
    String[] tiempos = {"1", "2", "3", "4"};
    String[] num_titulares = {"7","6","5"};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.cambiartiempos);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            final WindowInsetsController insetsController = getWindow().getInsetsController();
            if (insetsController != null) {
                insetsController.hide(WindowInsets.Type.statusBars());
            }
        } else {
            getWindow().setFlags(
                    WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN
            );
        }

        TextView textMins = findViewById(R.id.textMins);
        TextView textPartes = findViewById(R.id.textPartes);
        TextView textTitulares = findViewById(R.id.textTitulares);


        Spinner listaminutos = findViewById(R.id.minspinner);
        Spinner listatiempos = findViewById(R.id.tiempospinner);
        Spinner listatitulares = findViewById(R.id.titularesspinner);

        ArrayAdapter<String> adaptador1 = new ArrayAdapter<>(this, android.R.layout.simple_spinner_item, minutos);
        listaminutos.setAdapter(adaptador1);
        ArrayAdapter<String> adaptador2 = new ArrayAdapter<>(this, android.R.layout.simple_spinner_item, tiempos);
        listatiempos.setAdapter(adaptador2);
        ArrayAdapter<String> adaptador3 = new ArrayAdapter<>(this, android.R.layout.simple_spinner_item, num_titulares);
        listatitulares.setAdapter(adaptador3);



        listaminutos.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {

            // Este método es llamado cuando se selecciona un item en el spinner
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
                String mins = (String) parent.getItemAtPosition(pos);
                textMins.setText(mins);
            }

            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
                // TODO Auto-generated method stub
            }
        });


        listatiempos.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            // Este método es llamado cuando se selecciona un item en el spinner
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
                String partes = (String) parent.getItemAtPosition(pos);
                textPartes.setText(partes);
            }

            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
                // TODO Auto-generated method stub

            }
        });

        listatitulares.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            // Este método es llamado cuando se selecciona un item en el spinner
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int pos, long id) {
                String titulares = (String) parent.getItemAtPosition(pos);
                textTitulares.setText(titulares);
            }

            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
                // TODO Auto-generated method stub

            }
        });




        Button guardartiempos = findViewById(R.id.guardatiempos);
        guardartiempos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Partido partido = new Partido();
                String partes = textPartes.getText().toString();
                String mins = textMins.getText().toString();
                String titulares = textTitulares.getText().toString();
                partido.setDuracion(Integer.parseInt(mins));
                partido.setPartes(Integer.parseInt(partes));
                partido.setNumTitulares(Integer.parseInt(titulares));
                GlobalVars.MAX_TIT = Integer.parseInt(titulares);
                guardarPartido(partido);
                Intent intent = new Intent(CambiarTiempos.this, MainActivity.class);
                startActivityForResult(intent, 0);
            }
        });
    }

    private void guardarPartido(Partido partido) {
        MatchDB conn=new MatchDB(this,"bd_partidos",null,1);

        SQLiteDatabase db=conn.getWritableDatabase();
        ContentValues values=new ContentValues();
        String[] parametros={String.valueOf(GlobalVars.IDRESULTANTE)};
        values.put("partes",partido.getPartes());
        values.put("duracion",partido.getDuracion());
        values.put("numTitulares",partido.getNumTitulares());
        db.update(GlobalVars.TABLA_PARTIDO,values,"_id=?",parametros);
        db.close();
        Log.d("Tiempos", "guardadito");
    }
}